define([
    'underscore',
    'backbone',
    'App',
    'marionette',
    'text!modules/vha-enrollment/vha-enrollment.html',
    'modules/page/popup/external-nav-behavior',
    'modules/learn-about-community-care/learn-about-community-care-popup-view',
],
function (_, Backbone, app, Marionette, template, ExternalNavigation, LearnAboutCCPopup) {
    'use strict';

    return Backbone.Marionette.View.extend({
        className: 'vha-enrollment modal-content ui-body ui-body-b ui-corner-all ui-shadow',
        template: _.template(template),
        events: {'click #learn-cc': 'showLearnAboutCC'},
        showLearnAboutCC: function(e) {
            var learnAboutCCPopup = new LearnAboutCCPopup({elAfterClose: '#learn-cc'});
            learnAboutCCPopup.openPopup();
        },
        behaviors: {ExternalNavigation: {behaviorClass: ExternalNavigation}},
        templateContext: function () {
            return {ccIsDisabled: typeof app.disabledFeatures.get('CC_FEATURE_SET') !== 'undefined'};
        },
    });
});
